export default {
    methods: {
        generateHardwareSummary(server) {
            let hw = server?.detailedHardwareInformation;
            let out = '';

            if (!hw || !Object.keys(hw).length) {
                return 'No hardware details available';
            }

            if (hw.cpu?.count && hw.cpu?.model) {
                out += `${hw.cpu.count}x ${hw.cpu.model}` + ' | ';
            }

            if (hw.memory?.value) {
                let gbRam = this.formatByteToNice(hw.memory.value, 0, hw.memory.valueType);
                out += `RAM: ${gbRam}` + ' | ';
            }

            if (hw.disk?.details && hw.disk.details.length) {
                out += 'Disks: ' + this.groupSameSizes(hw.disk.details, hw.disk.valueType);
            }

            if (out === '') {
                return 'No hardware details available';
            }

            if (out.endsWith("| ")) {
                out = out.slice(0, -2);
            }

            return out;
        },

        groupSameSizes(data, valueType) {
            const sizeCount = data.reduce((acc, item) => {
                let sizeor = this.formatByteToNice(item.size, 0, valueType);
                acc[sizeor] = (acc[sizeor] || 0) + 1;
                return acc;
            }, {});

            return Object.entries(sizeCount)
                .map(([size, count]) => `${count}x ${size}`)
                .join(', ');
        },

        getModuleSettingByName(name) {
            if (this.$simpleStore.getModuleSettings()?.[name]) {
                return this.$simpleStore.getModuleSettings()[name];
            }

            return null;
        },
    }
}