export default {
    template: `
        <div>
            <div class="modal fade" ref="dynamicIpAssignmentTest" role="dialog" tabindex="0">
                <div class="modal-dialog modal-lg" role="document">
                    <div class='modal-content panel panel-primary'>
                        <div class='modal-header panel-heading'>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                            <h4 class="modal-title">Test Configuration</h4>
                        </div>

                        <div class='modal-body panel-body'>
                            <div class="alert dservermanager-alert-secondary">
                                <div>
                                    The test preview shows the exact API configuration payload that would be used during service creation, without making any actual changes. After reviewing the preview, you can optionally execute the test configuration, which will perform the action and update the IPs stored in WHMCS.
                                </div>

                                <div style="margin-top: 5px;">
                                    The test takes into account all relevant settings: global configuration, product configuration, and configurable options.
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="serviceId">Enter the WHMCS Service ID</label>

                                <div class="input-group">
                                    <input type="number" class="form-control" id="serviceId" v-model="serviceId" placeholder="Enter Service ID">

                                    <span class="input-group-btn">
                                        <button @click.prevent="testServiceConfiguration()" type="button" class="btn btn-primary" :disabled="!serviceId || loading">
                                            Test Configuration
                                        </button>
                                    </span>
                                </div>
                            </div>

                            <div v-if="result.payload || result.error" style="margin-top: 25px;">
                                <h4>Test Results</h4>

                                <div class="alert alert-danger" v-if="result.error">
                                    <b>Error:</b>
                                    <br/>
                                    <pre v-if="formattedError.isJson" style="max-height: 300px; overflow-y: auto;">{{ formattedError.text }}</pre>
                                    <span v-else>{{ formattedError.text }}</span>
                                </div>

                                <div class="panel panel-default" v-if="result.payload">
                                    <div class="panel-heading">
                                        <h3 class="panel-title">API Payload</h3>
                                    </div>

                                    <div class="panel-body">
                                        <pre style="max-height: 600px; overflow-y: auto;">{{ JSON.stringify(result.payload, null, 2) }}</pre>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-4" v-if="result.payload">
                                        <button @click.prevent="testServiceConfiguration(true)" type="button" class="btn btn-danger btn-block" :disabled="!serviceId || loading">
                                            <b>Click To Execute API Call</b>
                                        </button>
                                    </div>

                                    <div class="col-md-4">
                                        <a target="_blank" :href="'clientsservices.php?id=' + serviceId" class="btn btn-default btn-block">
                                            <b>Open WHMCS Service Page</b>
                                        </a>
                                    </div>

                                    <div class="col-md-4" v-if="result.productId">
                                        <a target="_blank" :href="'configproducts.php?action=edit&id=' + result.productId" class="btn btn-default btn-block">
                                            <b>Open WHMCS Product Page</b>
                                        </a>
                                    </div>
                                </div>

                                <div class="panel panel-default" v-if="result.response" style="margin-top: 15px;">
                                    <div class="panel-heading">
                                        <h3 class="panel-title">API Response</h3>
                                    </div>

                                    <div class="panel-body">
                                        <pre style="max-height: 600px; overflow-y: auto;">{{ JSON.stringify(result.response, null, 2) }}</pre>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    `,

    props: [
        'xhrUrl'
    ],

    mounted() {
    },

    data() {
        return {
            serviceId: null,
            result: {
                payload: null,
                response: null,
                error: null,
                productId: null,
            },
            loading: false,
        }
    },


    computed: {
        formattedError() {
            const errorData = this.result.error;
            let isJson = false;
            let text = '';

            if (typeof errorData === 'string') {
                try {
                    const parsed = JSON.parse(errorData);

                    if (parsed && typeof parsed === 'object') {
                        isJson = true;
                        text = JSON.stringify(parsed, null, 2);
                    } else {
                        text = errorData;
                    }
                } catch (e) {
                    text = errorData;
                }
            } else if (errorData && typeof errorData === 'object') {
                isJson = true;

                try {
                    text = JSON.stringify(errorData, null, 2);
                } catch (e) {
                    text = errorData.toString();
                }
            } else {
                text = errorData;
            }

            return {
                isJson,
                text
            }
        }
    },

    methods: {
        openModal() {
            jQuery(this.$refs.dynamicIpAssignmentTest).appendTo('body').modal('show');
        },

        async testServiceConfiguration(perform = false) {
            if (!perform) {
                this.result.payload = null;
            }

            this.result.error = null;
            this.result.response = null;
            this.result.productId = null;
            this.loading = true;

            try {
                let res = await axios.post(`${this.xhrUrl}testDynamicIpAssignmentSettings&pid=${this.serviceId}&perform=${perform ? 1 : 0}`);

                this.result.payload = res.data.payload;
                this.result.productId = res.data.productId;
                this.result.response = res.data?.response;
            } catch (e) {
                this.result.error = e.response.data;
            } finally {
                this.loading = false;
            }
        }
    }
}