export default {
    template: `
        <div class='panel panel-default col-md-12 serverbox' style='box-shadow: rgba(99, 99, 99, 0.2) 0px 2px 8px 0px;' :key='"sb_" + whmcsProductId + "_" + index' :id="'serverbox_id_' + server.uniqueVueId">
            <div class='panel-body' style='padding-left: 0px; padding-right: 0px;'>
                <div class='col-md-12' style='padding-left: 0px; padding-right: 0px;'>
                    <span :class="disableDrag === 'yes' ? '' : 'appDragHandler'" data-toggle="dynamic-tooltip"
                          :title="disableDrag === 'yes' ? 'Drag and drop is not available if pagination is enabled. Use the quick move tool instead (Tools -> Quick Move To)' : ''" :style="disableDrag === 'yes' ? 'opacity: 0.5' : ''">
                        <i class='fas fa fa-bars' style='margin-right: 5px;'></i>
                    </span>

                    <span style='font-size: 16px; font-weight: 500;'>
                        <a :href="computedServernameHref" target='_blank'>{{ server.servername }}</a>
                        <small style="margin-left: 5px;" v-show="showServerDescription">{{ server.description || 'No description' }}</small>
                    </span>

                    <span class='pull-right' style='font-size: 16px;' data-toggle="dynamic-tooltip"
                          :title="server.cachedPowerstatus === 'probablyOnline' ? 'The power provider does not support querying the current status. The status has been guessed.' : 'Power status'">
                        <span class='label label-success' v-if="server.cachedPowerstatus === 'online'">online</span>
                        <span class='label label-success' v-if="server.cachedPowerstatus === 'probablyOnline'">online (probably)</span>
                        <span class='label label-danger' v-if="server.cachedPowerstatus === 'offline'">offline</span>
                        <span class='label label-default' v-if="server.cachedPowerstatus === null || server.cachedPowerstatus === 'unknown'">Unknown</span>
                    </span>
                </div>

                <div class="col-md-12" style='margin-top: 5px;' v-if="showServerHardwareSummary">
                    {{ generateHardwareSummary(server) }}
                </div>

                <div class='col-md-12' style='padding-left: 0px; padding-right: 0px; margin-top: 5px;'>
                    <span class='col-md-2 col-xs-12'>
                        <b>Server IP</b>
                        <br/>
                        <template v-if="server.primaryip">
                            {{ server.primaryip }}
                        </template>
                        <template v-else>
                            <span class="text-danger" data-toggle="dynamic-tooltip" title="Provisioning will fail because server has no IP address unless dynamic IP assignments are enabled for this product">
                                <b>No IP assigned</b>
                                <i class="fad fa fa-exclamation-circle"></i>
                            </span>
                        </template>
                    </span>

                    <span class='col-md-3 col-xs-12'>
                        <b>Hostname</b>
                        <br/>
                        {{ truncateLong(server.hostname, 50) }}
                    </span>

                    <span class='col-md-3 col-xs-12'>
                        <b>WHMCS Assignment</b>
                        <br/>
                        <template v-if="server.whmcs && server.whmcs.clientAssignment && server.whmcs.clientAssignment.whmcsAssignment && server.whmcs.clientAssignment.whmcsAssignment.clientId">
                            <a :href="computedWhmcsAssignmentHref" target='_blank'
                               class="text-success">{{ truncateLong(server.whmcs.clientAssignment.whmcsAssignment.firstname, 50) }} {{ truncateLong(server.whmcs.clientAssignment.whmcsAssignment.lastname, 50) }}
                            </a>
                            <span class="label" :class="server.whmcs.clientAssignment.whmcsAssignment.productStatus === 'Active' ? 'label-success' : 'label-danger'">{{ server.whmcs.clientAssignment.whmcsAssignment.productStatus }}</span>
                        </template>
                        <template v-else>
                            <em>
                                <span class='text-danger'>Not assigned</span>
                            </em>
                        </template>
                    </span>

                    <span class='col-md-3 col-xs-12'>
                        <b>App Assignment</b>
                        <br/>
                        <a :href="computedAppAssignmentHref" target='_blank'>
                            {{ truncateLong(server.owner_realname, 50) }}
                        </a>
                    </span>

                    <span class='col-md-1 col-xs-12' style='padding-right: 3px; margin-top: 20px;' v-if='allConfigurableOptions[whmcsProductId] && allConfigurableOptions[whmcsProductId].length > 0'>
                        <button class="btn btn-default btn-xs pull-right" @click="switchConfigOptionCollapseStateSingleServer (server.uniqueVueId)">
                            <i class='fal fa fa-chevron-down' style='font-size: 12px;' v-if="serverCollapseMapper[server.uniqueVueId].isVisible === false"></i>
                            <i class='fal fa fa-chevron-up' style='font-size: 12px;' v-if="serverCollapseMapper[server.uniqueVueId].isVisible === true"></i>
                        </button>
                    </span>
                </div>

                <template>
                    <div class='col-md-12' style='padding-left: 0px; padding-right: 0px; margin-top: 5px; margin-top: 10px;'>
                        <template v-if="server.whmcs && server.whmcs.configuration && server.whmcs.configuration.id">
                            <button data-toggle="dynamic-tooltip" title="Enable or disable the automated provisioning for this server" class="btn btn-success btn-xs" v-if="!server.whmcs.configuration.disableAutoSetup"
                                    @click="toggleAutoSetup (server.whmcs.configuration.id, 1, whmcsProductId, index)">
                                Auto-Setup Enabled
                            </button>
                            <button class="btn btn-warning btn-xs" data-toggle="dynamic-tooltip" title="Enable or disable the automated provisioning for this server" v-if="server.whmcs.configuration.disableAutoSetup"
                                    @click="toggleAutoSetup (server.whmcs.configuration.id, 0, whmcsProductId, index)">
                                Auto-Setup Disabled
                            </button>
                        </template>

                        <button :title="!server?.tags?.length ? 'No tags' : server.tags.join(', ')" data-toggle="dynamic-tooltip" @click="showTagsModal(server.tags)" :disabled="!server?.tags?.length"
                                class="btn btn-default btn-xs">{{ server?.tags?.length ? server?.tags?.length : '0' }} Tags
                        </button>

                        <div class="btn-group">
                            <a type="button" class="btn btn-default dropdown-toggle btn-xs" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                Tools
                                <span style="margin-left: 3px;" class="caret"></span>
                            </a>

                            <ul class="dropdown-menu">
                                <li class='dropdown-submenu'>
                                    <a class='dropdown-morespace' data-toggle='dropdown' href='#'>
                                        Quick move to
                                    </a>
                                    <ul class="dropdown-menu">
                                        <li v-for="(v, k) in $simpleStore.getAllBillingProductNames()" :key="'quickmove_' + v.id" v-if="parseInt(v.id) !== parseInt(whmcsProductId)">
                                            <a href="#" @click.prevent="$emit('quick-move', server, v.id)">{{ v.name }}</a>
                                        </li>
                                    </ul>
                                </li>
                            </ul>
                        </div>
                    </div>
                </template>

                <div class='col-md-12' style='padding-left: 0px; padding-right: 0px; margin-top: 5px;'
                     v-if='allConfigurableOptions[whmcsProductId] && allConfigurableOptions[whmcsProductId].length > 0 && serverCollapseMapper[server.uniqueVueId].isVisible === true' :key="'configOptions_' + index">
                    <hr style='margin-bottom: 0px; margin-top: 10px;'>
                    <template v-for='(configOption, key) in allConfigurableOptions[whmcsProductId]'>
                        <div class="clearfix" v-if="key % 4 === 0" :key="'clearfix_confOption_' + key + '_w_' + whmcsProductId + '_' + server.uniqueVueId + '_' + index"></div>
                        <div class='col-md-3' style='margin-top: 10px;' :key="'confOption_' + key + '_w_' + whmcsProductId + '_' + server.uniqueVueId + '_' + index">
                            {{ truncateLong(configOption.optionName, 45) }}
                            <br/>
                            <v-select :close-on-select="false" multiple label='name' :options='configOption.configOptions' :value='getStoredConfigOptions (server, configOption.optionId, configOption.configOptions)'
                                      @input='configOptionAssignmentChanges ($event, configOption.optionId, server, whmcsProductId, index)'></v-select>
                        </div>
                    </template>
                </div>
            </div>
        </div>
    `,

    computed: {
        computedServernameHref() {
            return `${this.ajaxUrl}sso&serverId=${this.server.id}&appId=${this.server.whmcs.appServerId}&appPage=servers&appRelId=${this.server.id}`;
        },
        computedAppAssignmentHref() {
            return `${this.ajaxUrl}sso&serverId=${this.server.id}&appId=${this.server.whmcs.appServerId}&appPage=users&appRelId=${this.server.user_id}`;
        },
        computedWhmcsAssignmentHref() {
            return `clientsservices.php?id=${this.server.whmcs.clientAssignment.whmcsAssignment.productId}`;
        },
        showServerDescription: function () {
            if (this.$simpleStore.getModuleSettings()['show_server_description_on_assignment_page'] === 'yes') {
                return true;
            }

            return false;
        },
        showServerHardwareSummary: function () {
            if (this.$simpleStore.getModuleSettings()['show_server_hardware_summary_on_assignment_page'] === 'yes') {
                return true;
            }

            return false;
        },
    },

    methods: {},


    props: [
        'server',
        'configOptionAssignmentChanges',
        'getStoredConfigOptions',
        'toggleAutoSetup',
        'switchConfigOptionCollapseStateSingleServer',
        'allConfigurableOptions',
        'index',
        'whmcsProductId',
        'serverCollapseMapper',
        'ajaxUrl',
        'showTagsModal',
        'disableDrag'
    ],
}