export default {
    template: `
        <div class="pull-right">
        <div class="btn-group" role="group" aria-label="Page navigation">
            <button :disabled="currentPage <= 0" @click="changePage(0)" class="btn btn-default btn-sm">
                <i class="fa fa-angle-double-left"></i>
            </button>

            <button :disabled="currentPage <= 0" @click="changePage(currentPage - 1)" class="btn btn-default btn-sm">
                <i class="fa fa-chevron-left"></i>
            </button>
        </div>

        <span>
            Page
            <input type="number" v-model.number="displayedPage" min="1" :max="totalPageCount" class="form-control input-sm" style="width: 60px !important; display: inline !important;" @input="changePage(displayedPage - 1)">
            of {{ totalPageCount }}
        </span>

        <div class="btn-group" role="group" aria-label="Page navigation">
            <button :disabled="currentPage >= totalPageCount - 1" @click="changePage(currentPage + 1)" class="btn btn-default btn-sm">
                <i class="fa fa-chevron-right"></i>
            </button>

            <button :disabled="currentPage >= totalPageCount - 1" @click="changePage(totalPageCount - 1)" class="btn btn-default btn-sm">
                <i class="fa fa-angle-double-right"></i>
            </button>
        </div>

        <span class="dropdown">
            <button class="btn btn-default dropdown-toggle btn-sm" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                {{ perPage }} per page
            </button>
            <ul class="dropdown-menu">
                <li>
                    <a href="#" v-for="size in [5, 10, 20, 40, 60, 100, 200, 1000]" @click.prevent="changePerPage(size)">{{ size }}</a>
                </li>
            </ul>
        </span>
        </div>
    `,

    computed: {
        displayedPage: {
            get() {
                return this.currentPage + 1;
            },
            set(val) {
                if (val < 1) {
                    this.currentPage = 0;
                } else if (val > this.totalPageCount) {
                    this.currentPage = this.totalPageCount - 1;
                } else {
                    this.currentPage = val - 1;
                }
            }
        },
    },

    methods: {
        // changePage(newPage) {
        //     this.$emit('update:currentPage', newPage);
        // },
    },

    props: {
        currentPage: {
            type: Number,
            required: true
        },
        totalPageCount: {
            type: Number,
            required: true
        },
        perPage: {
            required: true
        },
        changePage: {
            type: Function,
            required: true
        },
        changePerPage: {
            type: Function,
            required: true
        }
    },
}