export default {
    template: `
        <div>
        <div v-if="paginatedServers.length && paginationEnabled === 'yes'" style="margin-bottom: 7px;" class="pull-right">
            <pagination-controls :current-page="currentPage" :total-page-count="totalPageCount" :per-page="itemsPerPage" :change-page="changePage" :change-per-page="changePerPage"/>
        </div>

        <slot :paginated-servers="paginatedServers"></slot>

        <pagination-controls v-if="paginatedServers.length && paginationEnabled === 'yes'" style="margin-bottom: 5px; margin-top: -5px;" :current-page="currentPage" :total-page-count="totalPageCount" :per-page="itemsPerPage" :change-page="changePage"
                             :change-per-page="changePerPage"/>
        </div>
    `,

    data() {
        return {
            currentPage: 0,
            pagination: {
                perPageByProduct: {},
                defaultPerPage: 5,
            },
            perPage: 5,
        }
    },

    computed: {
        totalPageCount() {
            return Math.ceil(this.servers.length / this.perPage);
        },

        paginatedServers() {
            if (this.paginationEnabled === 'yes') {
                const start = this.currentPage * this.perPage;
                const end = start + this.perPage;

                return this.servers.slice(start, end);
            } else {
                return this.servers;
            }
        },

        displayedPage: {
            get() {
                return this.currentPage + 1;
            },
            set(val) {
                if (val < 1) {
                    this.currentPage = 0;
                } else if (val > this.totalPageCount) {
                    this.currentPage = this.totalPageCount - 1;
                } else {
                    this.currentPage = val - 1;
                }
            }
        },

        itemsPerPage() {
            if (this.pagination.perPageByProduct?.[this.productId]) {
                this.changePerPage(parseInt(this.pagination.perPageByProduct[this.productId]));
                return parseInt(this.pagination.perPageByProduct[this.productId]);
            }

            let customAmount = this.getModuleSettingByName('serverassignments_pagination_default_num');

            if (customAmount && customAmount != 0) {
                this.changePerPage(customAmount);
                return parseInt(customAmount);
            }

            this.changePerPage(this.perPage);
            return this.perPage;
        },
    },

    watch: {
        paginatedServers(val) {
            if (!val.length && this.totalPageCount > 0) {
                this.changePage(this.totalPageCount - 1);
            }
        },
        currentPage(val) {
            this.$emit('update:currentPage', val);
        },
        perPage(val) {
            this.$emit('update:perPage', val);
        }
    },

    props: {
        servers: {
            type: Array,
            required: true
        },
        paginationEnabled: {},
        productId: {},
    },

    methods: {
        changePerPage(size) {
            this.perPage = size;
            // ensure current page is not out of range after per page change
            if (this.currentPage > this.totalPageCount - 1) {
                this.currentPage = this.totalPageCount - 1;
            }

            this.$set(this.pagination.perPageByProduct, this.productId, size);
        },

        changePage(page) {
            this.currentPage = page;
        },
    }
}