export default {
    template: `
        <div>
            <div class="modal ds-modal fade" :id="'subnetsRdnsModalOverview_' + _uid" tabindex="0" role="dialog" aria-labelledby="alertDialog" aria-hidden="true" @click.self="close()">
                <div class="modal-dialog ds-modal-lg modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header bg-primary text-white">
                            <h5 class="modal-title">{{ jsToLang('modal.subnet_rdns.overview.title') }}</h5>
                        </div>

                        <div class="modal-body">
                            <template v-if="loaded === 1">
                                <table class="table ds-table-no-top-border ds-table-td-vertical" style="margin-bottom: 5px;">
                                    <thead>
                                    <tr style="display: revert !important;">
                                        <th>{{ jsToLang('modal.subnet_rdns.overview.table.ip') }}</th>
                                        <th width="55%">{{ jsToLang('modal.subnet_rdns.overview.table.record') }}</th>
                                        <th v-if="dCan('servers.ipassignments.update.param.ptrRecord')" style="text-align: center;" width="1%">{{ jsToLang('modal.subnet_rdns.overview.table.actions') }}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr style="display: revert !important;" v-for="(v, k) in rdnsSubnetModal.tableContent" :key="'ipassignments_' + k" v-if="rdnsSubnetModal.tableContent.length">
                                        <td style="vertical-align: middle;">
                                            {{ v.ip }}
                                        </td>
                                        <td style="vertical-align: middle;">
                                            <editable-field max-length="200" permission-to-edit="servers.ipassignments.update.param.ptrRecord" :loading="$simpleStore.getLoader('updateSubnetRdns_' + v.ip)"
                                                            @change="updateRdnsEntryForSubnet(v.ip, $event)" :text="v.ptrRecord"></editable-field>
                                        </td>
                                        <td style="text-align: center; vertical-align: middle; padding: 0;" v-if="dCan('servers.ipassignments.update.param.ptrRecord')">
                                            <d-button class="btn btn-danger" style="margin-top: 5px; margin-bottom: 5px;" @click.native="deleteRdnsEntryFromSubnet(v.ip)" :loading="$simpleStore.getLoader('deleteSubnetRdns_' + v.ip)">
                                                <i v-if="!$simpleStore.getLoader('deleteSubnetRdns_' + v.ip)" :class="faIconRepo('fa-trash')"></i>
                                            </d-button>
                                        </td>
                                    </tr>

                                    <tr v-if="!rdnsSubnetModal.tableContent.length">
                                        <td colspan="100%" class="text-center" style="line-height: 2 !important; vertical-align: middle;">
                                            {{ jsToLang('modal.subnet_rdns.overview.table.no_records') }}
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </template>

                            <template v-else>
                                <div class="text-center">
                                    <i style="font-size: 30px; margin-top: 10px; margin-bottom: 10px;" :class="faIconRepo('fa-refresh-spin')"></i>
                                    <br/>
                                    {{ jsToLang('generic.text.loading') }}
                                </div>
                            </template>
                        </div>

                        <div class="modal-footer panel-footer card-footer">
                            <button type="button" class="btn btn-secondary pull-left float-left" @click="close()">
                                <i :class="faIconRepo('fa-times')" style="margin-right: 3px;"></i>
                                {{ jsToLang('generic.button.close') }}
                            </button>

                            <button @click="createSubnetRdnsEntryModal" type="button" class="btn btn-success pull-right float-right" v-if="dCan('servers.ipassignments.update.param.ptrRecord')">
                                <i :class="faIconRepo('fa-plus')" style="margin-right: 3px;"></i>
                                {{ jsToLang('modal.subnet_rdns.overview.button.add') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="modal ds-modal fade" :id="'subnetsRdnsModalCreate_' + _uid" tabindex="0" role="dialog" aria-labelledby="alertDialog" aria-hidden="true" @click.self="closeCreate()">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header bg-primary text-white">
                            <h5 class="modal-title">{{ jsToLang('modal.subnet_rdns.create.title') }}</h5>
                        </div>

                        <div class="modal-body">
                            <label>{{ jsToLang('modal.subnet_rdns.create.form.enter_ip') }}</label>

                            <div class="form-group">
                                <input type="text" class="form-control" v-model="rdnsSubnetModal.recordForm.values.ip">
                            </div>

                            <div class="form-group" style="margin-top: 15px;">
                                <label>{{ jsToLang('modal.subnet_rdns.create.form.enter_record') }}</label>
                                <input type="text" class="form-control" v-model="rdnsSubnetModal.recordForm.values.ptrRecord">
                            </div>
                        </div>

                        <div class="modal-footer panel-footer card-footer">
                            <button type="button" class="btn btn-secondary pull-left float-left" @click="closeCreate()">
                                <i :class="faIconRepo('fa-times')" style="margin-right: 3px;"></i>
                                {{ jsToLang('generic.button.close') }}
                            </button>

                            <d-button @click.native="updateRdnsEntryForSubnet()" type="button" class="btn btn-success pull-right float-right" :loading="$simpleStore.getLoader('addSubnetRdns_' + rdnsSubnetModal.recordForm.values.ip)">
                                <i v-if="!$simpleStore.getLoader('addSubnetRdns_' + rdnsSubnetModal.recordForm.values.ip)" :class="faIconRepo('fa-plus')" style="margin-right: 3px;"></i>
                                {{ jsToLang('modal.subnet_rdns.create.form.button.add') }}
                            </d-button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    `,

    data() {
        return {
            rdnsSubnetModal: {
                showOverview: false,
                showCreate: false,
                tableContent: [],
                recordForm: {
                    values: {
                        subnet: '',
                        ip: '',
                        ptrRecord: '',
                    },
                },
            },
            loaded: 0,
        }
    },

    watch: {},

    computed: {},

    methods: {
        createSubnetRdnsEntryModal() {
            //this.rdnsSubnetModal.recordForm.values.ip = '';
            this.rdnsSubnetModal.recordForm.values.ptrRecord = '';
            jQuery('#subnetsRdnsModalCreate_' + this._uid).modal({show: true});
            jQuery('#subnetsRdnsModalOverview_' + this._uid).css('z-index', 1039);
        },

        async deleteRdnsEntryFromSubnet(ip) {
            this.$simpleStore.addLoader('deleteSubnetRdns_' + ip);
            await this.updateRdnsEntryForSubnet(ip, '', 1);
        },

        async updateRdnsEntryForSubnet(manualIp, manualPtrRecord, noLoader) {
            if (!this.dCan('servers.ipassignments.update.param.ptrRecord')) {
                return false;
            }

            let subnetIp = '';
            let ptrRecord = '';
            let mode = '';

            if (manualIp) {
                subnetIp = manualIp;
                ptrRecord = manualPtrRecord;
            } else {
                subnetIp = this.rdnsSubnetModal.recordForm.values.ip;
                ptrRecord = this.rdnsSubnetModal.recordForm.values.ptrRecord;
                mode = 'create';
            }

            if (!noLoader) {
                this.$simpleStore.addLoader('updateSubnetRdns_' + manualIp);
                this.$simpleStore.addLoader('addSubnetRdns_' + this.rdnsSubnetModal.recordForm.values.ip);
            }

            try {
                await axios.post(this.xhrUrl + 'updateIp', {
                    content: {
                        ip: this.rdnsSubnetModal.recordForm.values.subnet,
                        ptrRecord: ptrRecord,
                        subnetIp: subnetIp,
                    }
                });
            } catch (e) {
                this.$simpleStore.delLoader('deleteSubnetRdns_' + manualIp);
                this.$simpleStore.delLoader('updateSubnetRdns_' + manualIp);
                this.$simpleStore.delLoader('addSubnetRdns_' + this.rdnsSubnetModal.recordForm.values.ip);
                this.errorNotificationFlash(e.response?.data);
                return;
            }

            this.successNotificationFlash(this.jsToLang('notification.success.rdns_entry'));

            if (mode === 'create') {
                this.createSubnetRdnsEntryModal();
            }

            this.openSubnetRdnsModal(this.rdnsSubnetModal.recordForm.values.subnet, 1, [
                manualIp,
                this.rdnsSubnetModal.recordForm.values.ip
            ]);
        },

        async openSubnetRdnsModal(subnetIpWithCidr, noEmptyTable, removeLoaders) {
            this.rdnsSubnetModal.recordForm.values.ip = subnetIpWithCidr.split('/')[0];
            this.rdnsSubnetModal.recordForm.values.subnet = subnetIpWithCidr;

            if (!noEmptyTable) {
                this.rdnsSubnetModal.tableContent = [];
            }

            let getRecords = await axios.post(this.xhrUrl + 'getRdnsAssignmentByIp', {
                ip: subnetIpWithCidr
            });

            if (getRecords?.data?.ptrRecords) {
                this.rdnsSubnetModal.tableContent = getRecords.data?.ptrRecords;
            }

            if (removeLoaders && removeLoaders.length) {
                removeLoaders.forEach(v => {
                    this.$simpleStore.delLoader('deleteSubnetRdns_' + v);
                    this.$simpleStore.delLoader('updateSubnetRdns_' + v);
                    this.$simpleStore.delLoader('addSubnetRdns_' + v);
                });
            }

            this.loaded = 1;
        },

        async open(subnetIpWithCidr, noEmptyTable) {
            this.isOpen = 1;
            this.loaded = 0;
            jQuery('#subnetsRdnsModalOverview_' + this._uid).modal({show: true});
            this.openSubnetRdnsModal(subnetIpWithCidr, noEmptyTable);
        },

        close() {
            this.isOpen = 0;
            jQuery('#subnetsRdnsModalOverview_' + this._uid).modal('hide');
        },

        closeCreate() {
            jQuery('#subnetsRdnsModalCreate_' + this._uid).modal('hide');
            jQuery('#subnetsRdnsModalOverview_' + this._uid).css('z-index', 1050);
        },
    },

    props: [
        'xhrUrl',
    ],
}