export default {
    data() {
        return {
            sshKeyData: {},
        }
    },

    template: `
        <div class="modal fade" :id="'addSshKey_' + _uid" tabindex="-1" role="dialog" aria-labelledby="addSshKeyModal" aria-hidden="true">
            <div class="modal-dialog" role="document" style="max-width: 600px;">
                <div class="modal-content">
                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title">{{ jsToLang('modal.sshkey.title') }}</h5>
                    </div>

                    <div class="modal-body">
                        <div class="form-group">
                            <label>{{ jsToLang('modal.sshkey.form.name') }}</label>
                            <input v-model="sshKeyData.name" type="text" class="form-control">
                        </div>

                        <div class="form-group">
                            <label>{{ jsToLang('modal.sshkey.form.pubkey') }}</label>
                            <textarea v-model="sshKeyData.pubkey" rows="5" type="text" class="form-control" placeholder="ssh-rsa ..."></textarea>
                        </div>

                        <div class="form-group">
                            <label>{{ jsToLang('modal.sshkey.form.description') }}</label>
                            <input v-model="sshKeyData.description" type="text" class="form-control">
                        </div>
                    </div>

                    <div class="modal-footer panel-footer card-footer">
                        <button type="button" class="btn btn-secondary pull-left float-left" @click="close()">
                            <i :class="faIconRepo('fa-times')" style="margin-right: 3px;"></i>
                            {{ jsToLang('generic.button.close') }}
                        </button>

                        <d-button :loading="$simpleStore.getLoader('addSshKey')" @click.native="submitKey()" type="button" class="btn btn-primary pull-right float-right">
                            <i :class="faIconRepo('fa-plus')" style="margin-right: 3px;"></i>
                            {{ jsToLang('generic.button.add') }}
                        </d-button>
                    </div>
                </div>
            </div>
        </div>
    `,

    watch: {},

    computed: {},

    methods: {
        open() {
            this.sshKeyData = {
                name: '',
                pubkey: '',
                description: '',
            };

            jQuery('#addSshKey_' + this._uid).modal({show: true});
        },

        close() {
            jQuery('#addSshKey_' + this._uid).modal('hide');
        },

        async submitKey() {
            this.$simpleStore.addLoader('addSshKey');

            try {
                await axios.post(this.xhrUrl + 'addSshkey', {
                    content: this.sshKeyData,
                });

                await this.getUserAccount();
                this.$parent.addOrRemoveSshKey(this.sshKeyData.pubkey.trim());
                this.close();
            } catch (e) {
                this.errorNotificationFlash(e.response.data);
            } finally {
                this.$simpleStore.delLoader('addSshKey');
            }
        },
    },

    props: [
        'xhrUrl',
    ],
}