// this component is used if installation status tracking is not supported (root password is returned in that case), or if a post-action is available.

export default {
    data() {
        return {
            tableData: [],
            passwordDetails: {},
            collapseableTableData: {},
            showCollapseableTable: false,
            messages: {
                success: {
                    aboveTableText: '',
                    aboveTableSubText1: '',
                },
                danger: {
                    aboveTableText: '',
                    aboveTableSubText1: '',
                },
                collapseableTableDataHint: '',
            }
        }
    },

    template: `
        <div class="modal fade" :id="'showPasswordAfterInstall_' + _uid" tabindex="0" role="dialog" aria-labelledby="alertDialog" aria-hidden="true" @click.self="close()">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title">{{ jsToLang('modal.showPasswordAfterInstall.title') }}</h5>
                </div>

                <div class="modal-body">
                    <div v-if="messages.success.aboveTableText" class="alert alert-success">
                        <b>{{ messages.success.aboveTableText }}</b>

                        <br v-if="messages.success.aboveTableSubText1">
                        {{ messages.success.aboveTableSubText1 }}
                    </div>

                    <div v-if="messages.danger.aboveTableText" class="alert alert-danger">
                        {{ messages.danger.aboveTableText }}

                        <div v-if="messages.danger.aboveTableSubText1" style="margin-top: 10px;">
                            {{ messages.danger.aboveTableSubText1 }}
                        </div>
                    </div>

                    <a class="btn btn-primary btn-block" style="margin-top: 10px;" @click="showCollapseableTable = !showCollapseableTable" v-if="Object.keys(collapseableTableData).length">
                        {{ !showCollapseableTable ? jsToLang('modal.postaction.collapseableTable.additionalInformation.show') : jsToLang('modal.postaction.collapseableTable.additionalInformation.hide') }}
                    </a>

                    <div v-if="Object.keys(collapseableTableData).length && showCollapseableTable === true" style="margin-top: 20px;">
                        <small v-if="messages.collapseableTableDataHint !== ''">{{ messages.collapseableTableDataHint }}</small>
                        <table class="table ds-table-no-top-border ds-table-td-vertical" style="margin-top: 10px;">
                            <tbody>
                            <template v-for="(v, k) in collapseableTableData">
                                <tr v-if="typeof v === 'object'" :key="'execPostTask_tablHL_' + k">
                                    <td colspan="2">
                                        {{ k }}
                                    </td>
                                </tr>

                                <tr v-if="typeof v === 'object'" v-for="(value, key) in v" :key="'execPostTask_tableL_' + key">
                                    <td>
                                        <span style="margin-left: 15px;">{{ key }}</span>
                                    </td>
                                    <td>{{ value }}</td>
                                </tr>

                                <tr v-if="typeof v === 'string'" :key="'execPostTask_tableA_' + k">
                                    <td>{{ k }}</td>
                                    <td>{{ v }}</td>
                                </tr>
                            </template>
                            </tbody>
                        </table>
                    </div>

                    <template v-if="tableData.length">
                        {{ jsToLang('modal.showPasswordAfterInstall.postaction.description') }}

                        <table class="table ds-table-no-top-border" style="margin-top: 20px;">
                            <thead>
                            <tr>
                                <th class="text-left">
                                    {{ jsToLang('modal.showPasswordAfterInstall.postaction.table.type') }}
                                </th>
                                <th class="text-left">
                                    {{ jsToLang('modal.showPasswordAfterInstall.postaction.table.url') }}
                                </th>
                                <th class="text-left">
                                    {{ jsToLang('modal.showPasswordAfterInstall.postaction.table.username') }}
                                </th>
                                <th class="text-left">
                                    {{ jsToLang('modal.showPasswordAfterInstall.postaction.table.password') }}
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(v, k) in tableData" :key="'execPostTask_table_' + k">
                                <td>{{ v.type }}</td>
                                <td>{{ v.url }}</td>
                                <td>{{ v.username }}</td>
                                <td>{{ v.password }}</td>
                            </tr>
                            </tbody>
                        </table>
                    </template>

                    <template v-if="Object.keys(passwordDetails).length">
                        {{ jsToLang('modal.showPasswordAfterInstall.no_progress_tracking_only_password.description') }}

                        <table class="table ds-table-no-top-border" style="margin-top: 20px;">
                            <tbody>
                            <tr>
                                <td>
                                    {{ jsToLang('modal.showPasswordAfterInstall.no_progress_tracking_only_password.table.ip') }}
                                </td>
                                <td>
                                    {{ serverData.primaryip }}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    {{ jsToLang('modal.showPasswordAfterInstall.no_progress_tracking_only_password.table.username') }}
                                </td>
                                <td>
                                    root
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    {{ jsToLang('modal.showPasswordAfterInstall.no_progress_tracking_only_password.table.password') }}
                                </td>
                                <td>
                                    {{ passwordDetails.password }}
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </template>
                </div>

                <div class="modal-footer panel-footer card-footer">
                    <button type="button" class="btn btn-secondary pull-left float-left" @click="close()">
                        <i :class="faIconRepo('fa-times')" style="margin-right: 3px;"></i>
                        {{ jsToLang('generic.button.close') }}
                    </button>
                </div>
            </div>
        </div>
        </div>
    `,

    watch: {},

    computed: {},

    methods: {
        open(postTaskData, passwordDetails) {
            if (postTaskData?.postTaskAction === 'getPassword') {
                this.tableData = postTaskData.postTask;
            } else if (postTaskData?.postTaskAction === 'resetServerPassword') {
                if (postTaskData.postTask.error) {
                    this.messages.danger.aboveTableText = postTaskData.postTask.error;
                } else {
                    this.messages.success.aboveTableText = this.jsToLang('modal.serverPasswordReset.postaction.newPassword') + ' ' + postTaskData.postTask.newPassword;
                    this.messages.danger.aboveTableText = this.jsToLang('modal.serverPasswordReset.postaction.alert.message1');
                    this.messages.danger.aboveTableSubText1 = this.jsToLang('modal.serverPasswordReset.postaction.alert.message2');
                    this.messages.collapseableTableDataHint = this.jsToLang('modal.serverPasswordReset.postaction.collapseableTable.hint');
                    this.collapseableTableData = postTaskData.postTask.meta;

                    if (postTaskData.postTask?.sshKeysAdded) {
                        if (postTaskData.postTask.sshKeysAdded === 1) {
                            this.messages.success.aboveTableSubText1 = this.jsToLang('modal.serverPasswordReset.postaction.sshKeysAdded');
                        } else if (postTaskData.postTask.sshKeysAdded === 'notSupported') {
                            this.messages.success.aboveTableSubText1 = this.jsToLang('modal.serverPasswordReset.postaction.sshKeysNotSupported');
                        }
                    }
                }
            }

            if (passwordDetails) {
                this.passwordDetails = passwordDetails;
            }

            jQuery('#showPasswordAfterInstall_' + this._uid).modal({show: true});
        },

        close() {
            jQuery('#showPasswordAfterInstall_' + this._uid).modal('hide');
        }
    },

    props: [
        'serverData'
    ],
}