export default {
    data() {
        return {
            allProfiles: [],
            availableOsGroups: [],
            selectedOsGroupName: '',
            provisioningConfig: {
                profileId: null,
            },
            provisioningStatus: {},
            submitProvisioningData: {},
            adminMailSettings: {
                sendReinstallationMail: false,
                sendWelcomeMail: false,
            },
            tmpOsVersionSelector: [],
            oldTmpOsVersionSelector: [],
            profilesInitiallyLoaded: false,
        }
    },

    template: `
        <div class="row">
            <alert-modal ref="confirmReinstall"></alert-modal>
            <provisioning-status :get-server="getServer" :xhr-url="xhrUrl" :server-data="serverData" ref="showProvisioningStatus"></provisioning-status>
            <show-password-after-install :server-data="serverData" ref="showPasswordAfterInstall"></show-password-after-install>
            <ssh-key-modal :xhr-url="xhrUrl" ref="addSshKey"></ssh-key-modal>

            <template v-if="isInstallationRunning.running === 0">
                <template v-if="profilesInitiallyLoaded === false && mode !== ''" v-for="(v, k) in Array.from(Array(9).keys())">
                    <div class="col-md-4" style="padding-left: 10px; padding-right: 7px; margin-top: 5px;">
                        <div class="panel panel-default card panel-less-margin-bottom">
                            <div class="panel-body card-body text-center" style="padding: 10px !important;">
                                <skeleton>
                                    <div style="margin-top: 10px;"></div>
                                    <span class="dsSkeletonImageSmallSquare" style="display: inline-block;"></span>
                                    <div style="margin-top: 5px;"></div>
                                    <span style="width: 60%; display: inline-block;" class="dsSkeletonSmallText"></span>
                                    <div style="margin-top: 10px;"></div>
                                    <span style="display: inline-block;" class="dsSkeletonDropdown"></span>
                                </skeleton>
                            </div>
                        </div>
                    </div>
                </template>

                <template v-if="profilesInitiallyLoaded === true">
                    <template v-for="(v, k) in availableOsGroups">
                        <div class="clearfix" v-if="k % 3 === 0" :key="'massAssignmentsClearfix_confOption_' + k"></div>
                        <div class="col-md-4" :key="'availableProvisioningGroups_' + mode + '_' + k" v-bind:style="{
                                opacity: selectedOsGroupName !== '' && selectedOsGroupName !== v.name ? '0.6' : '',
                            }" style="transition: opacity 150ms ease-in-out; padding-left: 10px; padding-right: 7px; margin-top: 5px;">
                            <div class="panel panel-default card panel-less-margin-bottom">
                                <div class="panel-body card-body">
                                    <div class="text-center">
                                        <img style="max-height: 60px;" :src="xhrUrl + 'getImage&path=' + v.logo">
                                    </div>

                                    <div class="text-center ds-margin-bottom-5px" style="margin-top: 10px; font-size: 16px;">
                                        {{ v.name }}
                                    </div>
                                </div>

                                <hr style="margin-top: 0px; margin-bottom: 0px;">

                                <div class="panel-body card-body" style="padding-top: 10px; padding-bottom: 10px;">
                                    <select class="form-control" v-model="tmpOsVersionSelector[k]">
                                        <option selected disabled hidden :value="null">Select version</option>
                                        <option :value="os.id" v-for="(os, index) in allProfiles.filter(item => item.groupname === v.name)" :key="'selectOs_' + mode + '_' + index">
                                            {{ os.name }}
                                        </option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </template>

                    <template v-if="!availableOsGroups.length && mode !== ''">
                        <div class="col-md-12">
                            <div class="alert alert-danger">
                                {{ jsToLang('reinstallation.text.no_profiles_available') }}
                            </div>
                        </div>
                    </template>

                    <div class="col-md-12" style="margin-top: 20px" v-show="selectedProfileData?.features?.allow_ssh_keys === 1 && showSshKeys" v-if="dCan('servers.provisioning.startReinstallation.param.sshkeys')">
                        <h5>{{ jsToLang('reinstallation.ssh_keys.title') }}</h5>

                        <div class="row" style="margin-top: 15px;">
                            <template v-for="(v, k) in $simpleStore.getUserAccountData().sshKeys">
                                <div class="clearfix" v-if="k % 3 === 0" :key="'availableSshkeysClearfix_' + k"></div>
                                <div @click="addOrRemoveSshKey(v.pubkey)" class="col-md-4 ds-mouse-pointer" :key="'availableSshkeys_' + mode + '_' + k" style="padding-left: 10px; padding-right: 7px;">
                                    <div class="panel panel-default card panel-less-margin-bottom">
                                        <div class="panel-body card-body" style="padding-top: 10px; padding-bottom: 10px;">
                                            <div class="text-center" style="font-size: 1.1em;">
                                                {{ v.name }}
                                            </div>

                                            <div class="text-center" style="margin-top: 0px">
                                                <small>{{ v.description ? v.description : jsToLang('reinstallation.ssh_keys.card.no_desc') }}</small>
                                            </div>
                                        </div>

                                        <hr style="margin-top: 0px; margin-bottom: 0px;">

                                        <div class="panel-body card-body text-center" :class="isSshKeySelected(v.pubkey) ? 'btn-success' : ''" style="padding-top: 5px; padding-bottom: 5px;">
                                            <i :class="isSshKeySelected(v.pubkey) ? faIconRepo('fa-check') : faIconRepo('fa-ban')" style='font-size: 18px;'></i>
                                        </div>
                                    </div>
                                </div>
                            </template>

                            <div class="col-md-4 ds-mouse-pointer" @click="addNewSshKey" v-if="dCan('sshkeys.store')" style="padding-left: 10px; padding-right: 7px;">
                                <div class="panel panel-default card panel-less-margin-bottom">
                                    <div class="panel-body card-body">
                                        <div class="text-center">
                                            <i :class="faIconRepo('fa-key')" style='font-size: 26px;'></i>
                                        </div>

                                        <div class="text-center" style="margin-top: 13px">
                                            {{ jsToLang('reinstallation.ssh_keys.button.add_key') }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12" style="margin-top: 20px" v-if="isProfileConfigurable">
                        <h5 style="margin-bottom: 0px;">{{ jsToLang('reinstallation.configure_system.title') }}</h5>

                        <div class="row ds-flex">
                            <div class="col-md-6" style="margin-top: 15px;" v-show="selectedProfileData?.disklayouts && selectedProfileData?.disklayouts.length" v-if="dCan('servers.provisioning.startReinstallation.param.disklayoutId')">
                                {{ jsToLang('reinstallation.configure_system.select_disk_layout') }}
                                <select class="form-control" v-model="provisioningConfig.disklayoutId">
                                    <option selected disabled hidden value="">Select version</option>
                                    <option v-for="(v, k) in selectedProfileData?.disklayouts" :value="v.id">{{ v.name }}</option>
                                </select>
                            </div>

                            <div class="col-md-6" style="margin-top: 15px;" v-show="selectedProfileData?.scripts && selectedProfileData?.scripts.length" v-if="dCan('servers.provisioning.startReinstallation.param.runScripts')">
                                {{ jsToLang('reinstallation.configure_system.select_scripts') }}
                                <v-select :close-on-select="false" multiple label='name' :options="selectedProfileData?.scripts" v-model="provisioningConfig.runScripts"></v-select>
                            </div>

                            <div class="col-md-6" style="margin-top: 15px;" v-show="selectedProfileData?.features?.set_root_password === 1" v-if="dCan('servers.provisioning.startReinstallation.param.rootpassword')">
                                {{ jsToLang('reinstallation.configure_system.set_root_pw') }}
                                <input class="form-control" v-model="provisioningConfig.rootpassword">
                            </div>

                            <div class="col-md-6" style="margin-top: 15px;" v-show="selectedProfileData?.features?.allow_set_hostname === 1" v-if="dCan('servers.provisioning.startReinstallation.param.hostname')">
                                {{ jsToLang('reinstallation.configure_system.enter_hostname') }}
                                <input class="form-control" v-model="provisioningConfig.hostname">
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12" v-if="showAdminMailDiv && selectedProfileData" style="margin-top: 10px;">
                        <div class="checkbox" v-if="showAdminSendWelcomeMail.show">
                            <label>
                                <input type="checkbox" v-model="adminMailSettings.sendWelcomeMail">
                                Resend Welcome Mail
                            </label>
                        </div>

                        <div class="checkbox" v-if="showAdminSendReinstallMail.show">
                            <label>
                                <input type="checkbox" v-model="adminMailSettings.sendReinstallationMail">
                                Send Reinstallation Mail
                            </label>
                        </div>
                    </div>

                    <div class="col-md-12" style="margin-top: 25px;" v-show="selectedProfileData">
                        <d-button :disabled="!isStartProvisioningPossible" :loading="$simpleStore.getLoader('startProvisioning')" @click.native.prevent="startProvisioning" class="btn btn-danger">{{ computedStartInstallationButton }}</d-button>
                    </div>
                </template>
            </template>

            <template v-else>
                <div class="col-md-12">
                    <div class="alert alert-warning" v-if="!$simpleStore.getLoader('startProvisioning')">
                        <div>
                            {{ isInstallationRunning?.meta?.msgRunning }}
                        </div>

                        <div v-if="!serverData.postReinstallationActionAvailable || serverData.postReinstallationActionAvailable === ''">
                            <d-button :disabled="$simpleStore.getLoader('abortInstallation')" @click.native.prevent="followInstallProgress" class="btn btn-primary" style="margin-top: 10px;" v-if="dCan('servers.provisioning.getInstallStatus')">
                                <i :class="faIconRepo('fa-eye')" style="margin-right: 3px;"></i>
                                {{ jsToLang('reinstallation.button.follow_progress') }}
                            </d-button>
                            <d-button :loading="$simpleStore.getLoader('abortInstallation')" @click.native.prevent="abortInstallation"
                                      v-if="dCan('servers.provisioning.stopReinstallation') && provisioningStatus.canCancelInstallation === 1 && provisioningStatus.running === 1" class="btn btn-danger" style="margin-top: 10px; margin-left: 5px;">
                                <i v-if="!$simpleStore.getLoader('abortInstallation')" :class="faIconRepo('fa-ban')" style="margin-right: 3px;"></i>
                                {{ jsToLang('reinstallation.button.stop') }}
                            </d-button>
                        </div>

                        <div v-if="serverData.postReinstallationActionAvailable && serverData.postReinstallationActionAvailable !== ''">
                            <d-button :loading="$simpleStore.getLoader('executeInstallationPostAction')" class="btn btn-block btn-success" @click.native.prevent="installationPostAction()" style="margin-top: 10px;">
                                <i v-if="!$simpleStore.getLoader('executeInstallationPostAction')" :class="faIconRepo('fa-eye')" style="margin-right: 3px;"></i>
                                <template v-if="serverData.postReinstallationActionAvailable === 'getPassword'">
                                    {{ jsToLang('modal.installation_status.button.post_action_available.access_details') }}
                                </template>

                                <template v-if="serverData.postReinstallationActionAvailable === 'resetServerPassword'">
                                    {{ jsToLang('modal.installation_status.button.post_action_available.passwordReset') }}
                                </template>
                            </d-button>
                        </div>
                    </div>

                    <div class="alert alert-warning text-center" v-if="$simpleStore.getLoader('startProvisioning')">
                        <i style="font-size: 24px; margin-bottom: 7px;" :class="faIconRepo('fa-refresh-spin')"></i>
                        <br/>
                        {{ jsToLang('reinstallation.text.installation_submitted_loading_status') }}
                    </div>
                </div>
            </template>

        </div>
    `,

    watch: {
        'serverData': function (data) {
            if (!this.allProfiles.length) {
                this.setInitialProvisioningData();
                this.getAvailableProfiles();
            }
        },

        'serverData.reinstallationRunning': function (data) {
            if (data === 1) {
                this.getProvisioningStatus();
            }
        },

        'serverData.diskwipeRunning': function (data) {
            if (data === 1) {
                this.getProvisioningStatus();
            }
        },

        'serverData.rescueBootRunning': function (data) {
            if (data === 1) {
                this.getProvisioningStatus();
            }
        },

        'serverData.passwordResetRunning': function (data) {
            if (data === 1) {
                this.getProvisioningStatus();
            }
        },

        'serverData.hardwarecollectRunning': function (data) {
            if (data === 1) {
                this.getProvisioningStatus();
            }
        },

        'mode': function () {
            this.generateOsGroups();
            this.setInitialProvisioningData();
            this.selectedOsGroupName = '';
        },

        'tmpOsVersionSelector': {
            handler: function (newValues) {
                let profileId = newValues.find((val, i) => val !== this.oldTmpOsVersionSelector[i]);

                if (profileId) {
                    this.provisioningConfig.profileId = profileId;
                    this.tmpOsVersionSelector = this.tmpOsVersionSelector.map(val => val === profileId ? profileId : null);
                    this.oldTmpOsVersionSelector = [...this.tmpOsVersionSelector];
                }
            },
        },

        'provisioningConfig.profileId': function (selectedProfileId) {
            if (!selectedProfileId) {
                this.setInitialProvisioningData();
                this.selectedOsGroupName = '';
                return false;
            }

            // == is correct
            let selectedProfile = this.allProfiles.find(item => item.id == selectedProfileId);

            if (!selectedProfile) {
                return false;
            }

            this.selectedOsGroupName = selectedProfile.groupname;
            this.$set(this.provisioningConfig, 'runScripts', []);

            // set default values
            if (selectedProfile?.default_run_scripts?.length && selectedProfile?.scripts?.length) {
                for (const [key, value] of Object.entries(selectedProfile.default_run_scripts)) {
                    let getScript = selectedProfile.scripts.find(e => e.id === value);

                    if (getScript) {
                        this.provisioningConfig.runScripts.push(getScript)
                    }
                }
            }

            if (selectedProfile?.default_disklayout_template) {
                this.$set(this.provisioningConfig, 'disklayoutId', selectedProfile.default_disklayout_template)
            }
        }
    },

    computed: {
        showAdminMailDiv: function () {
            if (this.fromAdmin && Object.keys(this.$simpleStore.getAdminSettings()).length) {
                if (this.showAdminSendReinstallMail.show === true || this.showAdminSendWelcomeMail.show === true) {
                    return true;
                }
            }

            return false;
        },

        showAdminSendReinstallMail: function () {
            if (this.fromAdmin && this.$simpleStore.getAdminSettings()?.adminarea_reinstall_mail_template && this.$simpleStore.getAdminSettings().adminarea_reinstall_mail_template !== '') {
                return {
                    show: true,
                    prechecked: this.$simpleStore.getAdminSettings()?.adminarea_reinstall_precheck_send_reinstallation_mail === 'yes',
                };
            }

            return {
                show: false,
                prechecked: false,
            };
        },

        showAdminSendWelcomeMail: function () {
            if (this.fromAdmin && this.welcomeMailId && this.welcomeMailId !== '0') {
                return {
                    show: true,
                    prechecked: this.$simpleStore.getAdminSettings()?.adminarea_reinstall_precheck_resend_welcome_mail === 'yes',
                };
            }

            return {
                show: false,
                prechecked: false,
            };
        },

        showSshKeys: function () {
            if (this.dCan('sshkeys.store')) {
                return true;
            }

            if (!this.$simpleStore.getUserAccountData()?.sshKeys?.length) {
                return false;
            }

            return true;
        },

        isStartProvisioningPossible: function () {
            if (this.dCan('servers.provisioning.startReinstallation.param.rootpassword') && this.selectedProfileData?.features?.set_root_password === 1 && !this.provisioningConfig?.rootpassword?.trim()) {
                return false;
            }

            return true;
        },

        computedStartInstallationButton: function () {
            if (this.mode === 'reinstallation') {
                return this.jsToLang('reinstallation.button.start_install');
            } else if (this.mode === 'rescue') {
                return this.jsToLang('reinstallation.button.start_rescue');
            }
        },

        selectedProfileData: function () {
            // == is correct (profileId can be int and string)
            return this.allProfiles.find(item => item.id == this.provisioningConfig.profileId);
        },

        isInstallationRunning: function () {
            let mapper = {
                reinstallationRunning: {
                    type: 'reinstall',
                    msgRunning: this.jsToLang('card.reinstallation.running.installation'),
                    trueIf: 'int',
                },
                diskwipeRunning: {
                    type: 'diskwipe',
                    msgRunning: this.jsToLang('card.reinstallation.running.diskwipe'),
                    trueIf: 'int',
                },
                rescueBootRunning: {
                    type: 'rescue',
                    msgRunning: this.jsToLang('card.reinstallation.running.rescue'),
                    trueIf: 'int',
                },
                passwordResetRunning: {
                    type: 'rescue',
                    msgRunning: this.jsToLang('card.reinstallation.running.rescue'),
                    trueIf: 'int',
                },
                hardwarecollectRunning: {
                    type: 'hwcollect',
                    msgRunning: this.jsToLang('card.reinstallation.running.hwcollect'),
                    trueIf: 'int',
                },
                postReinstallationActionAvailable: {
                    type: 'postTaskAvailable',
                    msgRunning: this.jsToLang('card.reinstallation.running.postTaskAvailable'),
                    trueIf: 'string',
                }
            }

            for (const [field, installMeta] of Object.entries(mapper)) {
                if ((installMeta.trueIf === 'int' && this.serverData[field] === 1) || (installMeta.trueIf === 'string' && this.serverData[field] !== '')) {
                    return {
                        running: 1,
                        meta: installMeta,
                    }
                }
            }

            return {
                running: 0
            }
        },

        isProfileConfigurable: function () {
            if (!this.selectedProfileData) {
                return false;
            }

            if (this.selectedProfileData?.disklayouts && this.selectedProfileData?.disklayouts.length && this.dCan('servers.provisioning.startReinstallation.param.disklayoutId')) {
                return true;
            }

            if (this.selectedProfileData?.scripts && this.selectedProfileData?.scripts.length && this.dCan('servers.provisioning.startReinstallation.param.runScripts')) {
                return true;
            }

            if (this.selectedProfileData?.features?.set_root_password === 1 && this.dCan('servers.provisioning.startReinstallation.param.rootpassword')) {
                return true;
            }

            if (this.selectedProfileData?.features?.allow_set_hostname === 1 && this.dCan('servers.provisioning.startReinstallation.param.hostname')) {
                return true;
            }

            return false;
        }
    },

    methods: {
        async installationPostAction() {
            let data = await this.executeInstallationPostAction();

            if (data) {
                //this.$refs.showPasswordAfterInstall.open(data);
                this.openModal('showPasswordAfterInstall', data, null, 500);
            }

            this.getServer();
        },

        followInstallProgress() {
            if (this.selectedProfileData?.features?.follow_install_progress === 1 || !Object.keys(this.submitProvisioningData).length) {
                //this.$refs.showProvisioningStatus.open(this.submitProvisioningData?.rootpassword);
                this.openModal('showProvisioningStatus', this.submitProvisioningData?.rootpassword);
            } else {
                // this.$refs.showPasswordAfterInstall.open('', {
                //     password: this.submitProvisioningData.rootpassword
                // });
                this.openModal('showPasswordAfterInstall', '', {
                    password: this.submitProvisioningData.rootpassword
                }, 500);
            }
        },

        addNewSshKey() {
            //this.$refs.addSshKey.open();
            this.openModal('addSshKey', this.submitProvisioningData?.rootpassword);
        },

        async getProvisioningStatus() {
            try {
                let data = await axios.get(this.xhrUrl + 'getProvisioningStatus');
                this.provisioningStatus = data.data;
            } catch (e) {
                console.log(e.response.data);
            }
        },

        async startProvisioning() {
            let title = '';
            let desc = '';
            let btn = '';
            let alertMsg = '';

            if (this.mode === 'reinstallation') {
                title = 'modal.alert.reinstallation_start.title';
                desc = 'modal.alert.reinstallation_start.description';
                btn = 'modal.alert.reinstallation_start.acceptButton';
            } else if (this.mode === 'rescue') {
                title = 'modal.alert.rescue_start.title';
                desc = 'modal.alert.rescue_start.description';
                btn = 'modal.alert.rescue_start.acceptButton';
            }

            if (this.selectedProfileData?.isPasswordResetProfile === 1) {
                title = 'modal.alert.serverpasswordreset_start.title';
                desc = 'modal.alert.serverpasswordreset_start.description';
                btn = 'modal.alert.serverpasswordreset_start.acceptButton';
                alertMsg = 'modal.alert.serverpasswordreset_start.alertMessage'
            }

            if (await this.$refs.confirmReinstall.open(this.jsToLang(title), this.jsToLang(desc), '', this.jsToLang(btn), '', this.jsToLang(alertMsg))) {
                this.$simpleStore.addLoader('startProvisioning');

                // we need a hard copy of the obj
                let makeSubmitData = JSON.parse(JSON.stringify(this.provisioningConfig));

                if (makeSubmitData?.runScripts.length) {
                    makeSubmitData.runScripts = makeSubmitData.runScripts.flatMap((value) => value.id);
                }

                if (!this.dCan('servers.provisioning.startReinstallation.param.runScripts')) {
                    delete makeSubmitData.runScripts;
                }

                try {
                    let submitProvisioning = await axios.post(this.xhrUrl + 'startProvisioning', {
                        provisioningData: makeSubmitData,
                        adminMailSettings: this.adminMailSettings
                    });

                    this.submitProvisioningData = submitProvisioning.data;

                    await this.getServer();
                    this.followInstallProgress();
                } catch (e) {
                    this.errorNotificationFlash(e.response.data);
                } finally {
                    this.$simpleStore.delLoader('startProvisioning');
                }
            }
        },

        async abortInstallation() {
            if (await this.$refs.confirmReinstall.open(this.jsToLang('modal.alert.reinstallation_stop.title'), this.jsToLang('modal.alert.reinstallation_stop.description'), '', this.jsToLang('modal.alert.reinstallation_stop.acceptButton'))) {
                this.$simpleStore.addLoader('abortInstallation')

                try {
                    await axios.get(this.xhrUrl + 'stopProvisioning');
                    await this.getServer();
                } catch (e) {
                    this.errorNotificationFlash(e.response.data);
                } finally {
                    this.$simpleStore.delLoader('abortInstallation');
                }
            }
        },

        addOrRemoveSshKey(pubKey) {
            if (this.provisioningConfig?.sshkeys?.includes(pubKey)) {
                this.provisioningConfig.sshkeys.splice(this.provisioningConfig.sshkeys.indexOf(pubKey), 1);
            } else {
                if (!this.provisioningConfig.sshkeys) {
                    this.$set(this.provisioningConfig, 'sshkeys', []);
                }

                this.provisioningConfig.sshkeys.push(pubKey);
            }
        },

        isSshKeySelected(pubKey) {
            if (this.provisioningConfig?.sshkeys?.includes(pubKey)) {
                return true;
            }

            return false;
        },

        setInitialProvisioningData() {
            this.provisioningConfig = {
                profileId: null,
            };

            if (this.dCan('servers.provisioning.startReinstallation.param.hostname') && !this.provisioningConfig.hostname) {
                this.$set(this.provisioningConfig, 'hostname', this.serverData.hostname);
            }

            if (this.dCan('servers.provisioning.startReinstallation.param.rootpassword') && !this.provisioningConfig.rootpassword) {
                let rootPw = '';

                if (this.$simpleStore.getServiceInformation()?.password) {
                    rootPw = this.$simpleStore.getServiceInformation().password;
                }

                if (rootPw === '') {
                    rootPw = this.generateRandomPassword()
                }

                this.$set(this.provisioningConfig, 'rootpassword', rootPw);
            }
        },

        generateOsGroups() {
            if (!this.allProfiles.length) {
                return false;
            }

            this.availableOsGroups = [];
            var items = {};

            if (this.mode === 'reinstallation') {
                items = this.allProfiles.filter(item => item.isRescue === 0);
            } else if (this.mode === 'rescue') {
                items = this.allProfiles.filter(item => item.isRescue === 1);
            }

            for (const [key, value] of Object.entries(items)) {
                // for dropdown workaround. Need v-model, but also need to keep placeholders
                this.$set(this.tmpOsVersionSelector, key, null);
                this.$set(this.oldTmpOsVersionSelector, key, null);

                if (!this.availableOsGroups.some(v => v.name === value.groupname)) {
                    this.availableOsGroups.push({
                        name: value.groupname,
                        logo: value.grouplogo
                    });
                }
            }
        },

        async getAvailableProfiles() {
            if (!this.serverData?.reinstallationprovider || this.serverData?.reinstallationprovider === '') {
                return false;
            }

            try {
                let req = await axios.get(this.xhrUrl + 'getAvailableProvisioningProfiles');
                this.allProfiles = req.data;
                this.generateOsGroups();

                this.adminMailSettings.sendWelcomeMail = this.showAdminSendWelcomeMail.prechecked;
                this.adminMailSettings.sendReinstallationMail = this.showAdminSendReinstallMail.prechecked;

                if (!this.allProfiles.length) {
                    this.$simpleStore.setProvisioningPossible(0);
                } else {
                    this.$simpleStore.setProvisioningPossible(1);
                }
            } catch (e) {
                this.$simpleStore.setProvisioningPossible(0);
                return false;
            } finally {
                this.profilesInitiallyLoaded = true;
            }
        }
    },

    props: [
        'xhrUrl',
        'serverData',
        'mode',
        'getServer',
        'fromAdmin',
        'welcomeMailId'
    ],
}