export default {
    data() {
        return {
            installProgressSteps: [],
            provisioningStatus: {},
            isOpen: 0,
            setTimeoutId: '',
            rootPassword: '',
        }
    },

    template: `
        <div>
            <show-password-after-install :server-data="serverData" ref="showPasswordAfterInstall"></show-password-after-install>
            <div class="modal fade" :id="'provisioningStatus_' + _uid" tabindex="0" role="dialog" aria-labelledby="alertDialog" aria-hidden="true" @click.self="close()">
                <div class="modal-dialog" role="document" style="max-width: 600px;">
                    <div class="modal-content">
                        <div class="modal-header bg-primary text-white">
                            <h5 class="modal-title">{{ jsToLang('modal.installation_status.title') }}</h5>
                        </div>

                        <div class="modal-body">
                            <div class="row" style="margin-top: 15px;">
                                <template v-if="Object.keys(provisioningStatus).length">
                                    <div class="col-md-12" v-for="(v, k) in installProgressSteps" :key="'installProgressSteps_' + k">
                                        <div class="col-md-12 font-size-16px">
                                            <span style="margin-left: 5px;">
                                                <template v-if="whichProvisioningIcon (v).isActive === 1">
                                                    <b>{{ v.text }}</b>
                                                </template>
                                                <template v-else>
                                                    {{ v.text }}
                                                </template>
                                            </span>

                                            <i class="pull-right float-right" :class="whichProvisioningIcon (v).icon" style='font-size: 18px; margin-right: 5px;'></i>
                                        </div>

                                        <hr style='opacity: 0.4;'>
                                    </div>

                                    <div class="col-md-12" v-if="this.rootPassword !== '' && !dCan('servers.provisioning.startReinstallation.param.rootpassword')">
                                        <div class="alert alert-success" style="margin-bottom: 0px;">
                                            {{ jsToLang('modal.installation_status.hint.rootpassword') }}
                                            <b>
                                                <code>{{ rootPassword }}</code>
                                            </b>
                                        </div>
                                    </div>

                                    <div class="col-md-12" v-if="getInstallationPostAction">
                                        <d-button :loading="$simpleStore.getLoader('executeInstallationPostAction')" class="btn btn-block btn-success" @click.native.stop="installationPostAction()">
                                            <i v-if="!$simpleStore.getLoader('executeInstallationPostAction')" :class="faIconRepo('fa-eye')" style="margin-right: 3px;"></i>
                                            <template v-if="serverData.postReinstallationActionAvailable === 'getPassword'">
                                                <b>{{ jsToLang('modal.installation_status.button.post_action_available.access_details') }}</b>
                                            </template>

                                            <template v-if="serverData.postReinstallationActionAvailable === 'resetServerPassword'">
                                                <b>{{ jsToLang('modal.installation_status.button.post_action_available.passwordReset') }}</b>
                                            </template>
                                        </d-button>
                                    </div>
                                </template>
                                <template v-else>
                                    <div class="col-md-12 text-center" style="margin-bottom: 15px;">
                                        <i style="font-size: 24px;" :class="faIconRepo('fa-refresh-spin')"></i>
                                    </div>
                                </template>
                            </div>
                        </div>

                        <div class="modal-footer panel-footer card-footer">
                            <button type="button" class="btn btn-secondary pull-left float-left" @click="close()">
                                <i :class="faIconRepo('fa-times')" style="margin-right: 3px;"></i>
                                {{ jsToLang('generic.button.close') }}
                            </button>

                            <d-button v-if="dCan('servers.provisioning.stopReinstallation') && provisioningStatus.canCancelInstallation === 1 && provisioningStatus.running === 1" :loading="$simpleStore.getLoader('abortInstallation')"
                                      @click.native="stopProvisioning" type="button" class="btn btn-danger pull-right float-right">
                                <i v-if="!$simpleStore.getLoader('abortInstallation')" :class="faIconRepo('fa-ban')" style="margin-right: 3px;"></i>
                                {{ jsToLang('modal.installation_status.button.stop') }}
                            </d-button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    `,

    watch: {},

    computed: {
        getInstallationPostAction: function () {
            if (this.dCan('servers.apiOutput.param.postReinstallationActionAvailable') && (this.serverData.postReinstallationActionAvailable && this.serverData.postReinstallationActionAvailable !== '')) {
                return this.serverData.postReinstallationActionAvailable;
            }

            return false;
        },
    },

    methods: {
        whichProvisioningIcon(v) {
            if (!Object.entries(this.provisioningStatus).length) {
                return {
                    icon: this.faIconRepo('fa-clock'),
                    isActive: 0,
                }
            }

            if (v.step !== '') {
                if (this.provisioningStatus.step === v.step) {
                    return {
                        icon: this.faIconRepo('fa-refresh-spin'),
                        isActive: 1,
                    }
                }

                if (this.provisioningStatus.step > v.step) {
                    return {
                        icon: this.faIconRepo('fa-check') + ' text-success',
                        isActive: 0,
                    }
                }

                if (this.provisioningStatus.step < v.step) {
                    return {
                        icon: this.faIconRepo('fa-clock'),
                        isActive: 0,
                    }
                }
            }

            if (v.completed) {
                if (this.provisioningStatus.running === 0) {
                    return {
                        icon: this.faIconRepo('fa-check') + ' text-success',
                        isActive: 1,
                    }
                }
            }

            return {
                icon: this.faIconRepo('fa-clock'),
                isActive: 0,
            }
        },

        installStates() {
            let installTypeLang = '';
            let installCompleteLang = '';

            if (this.serverData.hardwarecollectRunning === 1) {
                installTypeLang = this.jsToLang('modal.installation_status.type.hwcollect.pending');
                installCompleteLang = this.jsToLang('modal.installation_status.type.hwcollect.complete');
            } else if (this.serverData.diskwipeRunning === 1) {
                installTypeLang = this.jsToLang('modal.installation_status.type.diskwipe.pending');
                installCompleteLang = this.jsToLang('modal.installation_status.type.diskwipe.complete');
            } else if (this.serverData.reinstallationRunning === 1) {
                installTypeLang = this.jsToLang('modal.installation_status.type.reinstallation.pending');
                installCompleteLang = this.jsToLang('modal.installation_status.type.reinstallation.complete');
            } else if (this.serverData.rescueBootRunning === 1) {
                installTypeLang = this.jsToLang('modal.installation_status.type.rescue.pending');
                installCompleteLang = this.jsToLang('modal.installation_status.type.rescue.complete');
            } else if (this.serverData.passwordResetRunning === 1) {
                installTypeLang = this.jsToLang('modal.installation_status.type.passwortreset.pending');
                installCompleteLang = this.jsToLang('modal.installation_status.type.passwortreset.complete');
            }

            this.installProgressSteps = [
                {
                    text: this.jsToLang('modal.installation_status.step.reboot'),
                    step: 0,
                },
                {
                    text: this.jsToLang('modal.installation_status.step.prepare_boot_env'),
                    step: 1,
                },
                {
                    text: installTypeLang,
                    step: 2,
                },
                {
                    text: installCompleteLang,
                    completed: 1
                }
            ]
        },

        async stopProvisioning() {
            this.$simpleStore.addLoader('abortInstallation')
            this.close();

            try {
                await axios.get(this.xhrUrl + 'stopProvisioning');
                this.getServer();
            } catch (e) {
                this.errorNotificationFlash(e.response.data);
            } finally {
                this.$simpleStore.delLoader('abortInstallation');
            }
        },

        async getInstallStatus() {
            try {
                let data = await axios.get(this.xhrUrl + 'getProvisioningStatus');
                this.provisioningStatus = data.data;

                if (this.provisioningStatus.running === 1 && this.isOpen === 1) {
                    this.setTimeoutId = setTimeout(() => {
                        this.getInstallStatus();
                    }, 5000)
                } else {
                    // for fast ui update after completing the installation
                    this.getServer();
                }
            } catch (e) {
                console.log(e);
            }
        },

        async installationPostAction() {
            let data = await this.executeInstallationPostAction();

            if (data) {
                this.close();
                //this.$refs.showPasswordAfterInstall.open(data);
                this.openModal('showPasswordAfterInstall', data, null, 500);
            }

            this.getServer();
        },

        open(rootPassword) {
            this.rootPassword = rootPassword ? rootPassword : '';

            this.isOpen = 1;
            this.provisioningStatus = {};
            jQuery('#provisioningStatus_' + this._uid).modal({show: true});
            this.installStates();
            this.getInstallStatus();
        },

        close() {
            this.isOpen = 0;
            jQuery('#provisioningStatus_' + this._uid).modal('hide');
        }
    },

    props: [
        'xhrUrl',
        'serverData',
        'getServer',
    ],
}