function initialStateOpenConsole() {
    return {
        openingConsoleDialog: {
            show: false,
            step: 'pending',
            link: '',
            lastError: '',
            username: '',
            password: '',
        },
    }
}


export default {
    data: () => {
        return initialStateOpenConsole();
    },

    template: `
        <div class="modal fade" :id="'openServerConsole_' + _uid" tabindex="-1" role="dialog" aria-labelledby="openServerConsole" aria-hidden="true">
            <div class="modal-dialog" role="document" style="max-width: 600px;">
                <div class="modal-content">
                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title">
                            {{ jsToLang('modal.consoleDialog.title') }}
                        </h5>
                    </div>

                    <div class="modal-body">
                        <div class="text-center" v-if="openingConsoleDialog.step === 'pending'">
                            <i style="font-size: 30px; margin-bottom: 15px;" :class="faIconRepo('fa-refresh-spin')"></i>
                            <br/>
                            {{ jsToLang('modal.consoleDialog.preparing') }}
                        </div>

                        <template v-if="openingConsoleDialog.step === 'complete'">
                            <div class="text-center" style="margin-bottom: 15px; margin-top: 5px;">
                                <i :class="faIconRepo('fa-check-circle')" class="text-success" style="font-size: 44px;"></i>
                            </div>

                            <div class="text-center" v-if="openingConsoleDialog.username === ''">
                                {{ jsToLang('modal.consoleDialog.consoleAvailableDirectLink.text1') }}
                                <br/>
                                <a :href="openingConsoleDialog.link" target="_blank" class="text-decoration-none primary--text font-weight-medium">
                                    <b>{{ jsToLang('modal.consoleDialog.consoleAvailableDirectLink.text2') }}</b>
                                </a>
                            </div>

                            <div v-if="openingConsoleDialog.username !== ''">
                                <div class="text-center">
                                    {{ jsToLang('modal.consoleDialog.consoleAvailableExternalLink.topText') }}
                                </div>

                                <table class="table ds-table-no-top-border" style="margin-top: 20px;">
                                    <tbody>
                                    <tr>
                                        <td class="text-right">
                                            <b>{{ jsToLang('modal.consoleDialog.consoleAvailableExternalLink.table.url') }}</b>
                                        </td>
                                        <td>
                                            <a :href="openingConsoleDialog.link" target="_blank">
                                                <b>{{ openingConsoleDialog.link }}</b>
                                            </a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="text-right">
                                            <b>{{ jsToLang('modal.consoleDialog.consoleAvailableExternalLink.table.username') }}</b>
                                        </td>
                                        <td>{{ openingConsoleDialog.username }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-right">
                                            <b>{{ jsToLang('modal.consoleDialog.consoleAvailableExternalLink.table.password') }}</b>
                                        </td>
                                        <td>{{ openingConsoleDialog.password }}</td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </template>

                        <template v-if="openingConsoleDialog.step === 'failed'">
                            <div class="text-center alert alert-danger" style="margin-bottom: 0px;">
                                <b>{{ jsToLang('modal.consoleDialog.errorPrefix') }}</b>
                                {{ truncateLong(openingConsoleDialog.lastError, 100) }}
                            </div>
                        </template>
                    </div>

                    <div class="modal-footer panel-footer card-footer">
                        <button type="button" class="btn btn-secondary pull-left float-left" @click="close()">
                            <i :class="faIconRepo('fa-times')" style="margin-right: 3px;"></i>
                            {{ jsToLang('generic.button.close') }}
                        </button>
                    </div>
                </div>
            </div>
        </div>
    `,

    watch: {},

    computed: {},

    methods: {
        open(mode) {
            jQuery('#openServerConsole_' + this._uid).modal({show: true});
            Object.assign(this.$data, initialStateOpenConsole());
            this.startServerConsole(mode);
        },

        close() {
            jQuery('#openServerConsole_' + this._uid).modal('hide');
        },

        async startServerConsole(mode) {
            this.$simpleStore.addLoader('getServerConsole')

            this.openingConsoleDialog.link = '';
            this.openingConsoleDialog.username = '';
            this.openingConsoleDialog.password = '';

            try {
                let getServerConsoleRequest = await axios.get(this.xhrUrl + 'getServerConsole&mode=' + mode);
                let getServerConsole = getServerConsoleRequest.data;
                this.openingConsoleDialog.step = 'complete';

                if (getServerConsole.accessUrl && !getServerConsole?.username) {
                    window.open(getServerConsole.accessUrl, '_blank');
                    this.openingConsoleDialog.link = getServerConsole.accessUrl;
                } else if (getServerConsole?.username) {
                    // always show the modal if the response contain access details
                    this.openingConsoleDialog.link = getServerConsole.accessUrl;
                    this.openingConsoleDialog.username = getServerConsole?.username;
                    this.openingConsoleDialog.password = getServerConsole?.password;
                }

                // if the client closed the modal in the meantime, open it again.
                jQuery('#openServerConsole_' + this._uid).modal({show: true});
            } catch (e) {
                this.openingConsoleDialog.step = 'failed';
                this.openingConsoleDialog.lastError = e.response.data;
                this.errorNotificationFlash(e.response.data);
            } finally {
                this.$simpleStore.delLoader('getServerConsole')
            }
        },
    },

    props: [
        'xhrUrl',
    ],
}