export default {
    data() {
        return {
            switchToEdit: false,
            newEntry: '',
        }
    },

    template: `
        <div>
        <div v-if="!loading">
            <span @click="openEdit()" v-show="switchToEdit === false" :class="editClasses">
                <span v-if="outputText.html" v-html="outputText.text"></span>
                <span v-else>{{ outputText.text }}</span>
            </span>

            <div v-if="switchToEdit === true">
                <!-- negative margin to keep the table columns at the same height -->
                <div class="input-group" style="margin-top: -3px; margin-bottom: -4px;">
                    <input @change="newEntry = $event.target.value" @keyup.enter="changeEvent" type="text" ref="editableInput" :value="text" class="form-control input-sm form-control-sm" tabindex="0" @blur="closeInput()">
                    <div class="input-group-append input-group-btn">
                        <button class="btn btn-primary btn-sm" @click.prevent="changeEvent">
                            <i :class="faIconRepo('fa-check')" style="margin-right: 3px;"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div v-else>
            <i :class="faIconRepo('fa-refresh-spin')"></i>
        </div>
        </div>
    `,

    watch: {},

    computed: {
        editClasses: function () {
            let returnClasses = '';

            if (this.noneClass && this.canClickEdit) {
                returnClasses += this.noneClass;
            }

            if (this.canClickEdit) {
                returnClasses += ' ds-mouse-pointer ds-editable-text';
            }

            return returnClasses;
        },

        canClickEdit: function () {
            if (this.permissionToEdit) {
                if (!this.dCan(this.permissionToEdit)) {
                    return false;
                }
            }

            return true;
        },

        outputText: function () {
            var output = this.text;

            if (this.maxLength && this.text) {
                output = (this.text.length > this.maxLength) ? `${this.text.substring(0, this.maxLength)}…` : this.text
            }

            return {
                text: output,
                html: !!this.isHtml,
            }
        }
    },

    methods: {
        openEdit() {
            if (!this.canClickEdit) {
                return false;
            }

            this.switchToEdit = true;
            this.focusInput()
        },

        focusInput() {
            this.$nextTick(() => {
                this.$refs.editableInput.focus();
                this.$refs.editableInput.select();
            })
        },

        closeInput() {
            setTimeout(() => {
                this.switchToEdit = false;
            }, 150)
        },

        changeEvent() {
            this.$emit('change', this.newEntry);
            this.closeInput();
        }
    },

    props: [
        'text',
        'loading',
        'permissionToEdit',
        'isHtml',
        'noneClass',
        'maxLength',
    ],
}