import OpenServerConsole from './OpenServerConsole.js?v=b4';


export default {
    data: () => {
        return {}
    },

    template: `
        <span v-if="dCan('servers.console.start')">
            <open-server-console ref="openServerConsole" :xhr-url="xhrUrl" v-if="serverData.id"></open-server-console>

            <template v-if="isConsoleAvailable && isPowerStatusRelevant">
                <d-button v-if="!shouldShowDropdown" :disabled="$simpleStore.getLoader('setBmcReset')" :loading="$simpleStore.getLoader('getServerConsole')" @click.native="getServerConsole()" type="button" class="btn btn-default">
                    {{ jsToLang('card.actions.button.open_console') }}
                </d-button>

                <span v-else class="dropdown">
                    <d-button class="btn btn-default dropdown-toggle" type="button" data-toggle="dropdown" :disabled="$simpleStore.getLoader('setBmcReset')" :loading="$simpleStore.getLoader('getServerConsole')" aria-haspopup="true"
                              aria-expanded="false">
                        {{ jsToLang('card.actions.button.open_console') }}
                        <span style="margin-left: 3px;" class="caret"></span>
                    </d-button>

                    <ul class="dropdown-menu">
                        <li v-if="canUseStandardConsole">
                            <a class="dropdown-item" href="#" @click.prevent="getServerConsole('standard')">{{ jsToLang('card.actions.button.console_type_dropdown.standard') }}</a>
                        </li>
                        <li v-if="canUseWebConsole">
                            <a class="dropdown-item" href="#" @click.prevent="getServerConsole('web')">{{ jsToLang('card.actions.button.console_type_dropdown.web') }}</a>
                        </li>
                    </ul>
                </span>
            </template>
        </span>
    `,

    computed: {
        computedPowerStatus() {
            const status = this.serverData?.cachedPowerstatus;
            if (status === 'online' || status === 'probablyOnline') {
                return {
                    text: 'Online',
                    icon: 'green',
                };
            } else if (status === 'offline') {
                return {
                    text: 'Offline',
                    icon: 'red',
                };
            } else {
                return {
                    text: 'Unknown',
                    icon: 'yellow',
                };
            }
        },

        isConsoleAvailable() {
            const consoleProvider = this.serverData.consoleprovider;

            if (!consoleProvider) {
                return false;
            }

            if (consoleProvider.supportedConsoleMode === 'web+standard') {
                return this.dCan('servers.console.consoleMode.web') || this.dCan('servers.console.consoleMode.standard');
            }

            const modes = [
                'web',
                'standard'
            ];

            return modes.some(mode => {
                if (consoleProvider.supportedConsoleMode.includes(mode)) {
                    const permissionKey = `servers.console.consoleMode.${mode}`;
                    return this.dCan(permissionKey);
                }

                return false;
            });
        },

        isPowerProviderIpmi() {
            return this.serverData.powerprovider.type === "ipmi";
        },

        isConsoleProviderKvmSwitch() {
            const type = this.serverDetails?.consoleprovider?.type;
            return type === "kvm_switch" || type === "nanokvm" || type === "genericweb";
        },

        isPowerStatusRelevant() {
            if (this.serverData?.powerprovider === undefined || this.serverData?.powerprovider === null || this.serverData?.powerprovider.type === undefined) {
                return true;
            }

            const powerStatusText = this.computedPowerStatus.text;
            return powerStatusText === "Online" || (this.isPowerProviderIpmi && powerStatusText === "Offline") || (this.isConsoleProviderKvmSwitch && powerStatusText === "Offline");
        },

        isWebPlusStandard() {
            return this.serverData.consoleprovider && this.serverData.consoleprovider.supportedConsoleMode === "web+standard";
        },

        canUseWebConsole() {
            return this.dCan('servers.console.consoleMode.web') && this.serverData.consoleprovider.supportedConsoleMode.includes('web');
        },

        canUseStandardConsole() {
            return this.dCan('servers.console.consoleMode.standard') && this.serverData.consoleprovider.supportedConsoleMode.includes('standard');
        },

        shouldShowDropdown() {
            return this.isWebPlusStandard && this.canUseWebConsole && this.canUseStandardConsole;
        }
    },

    methods: {
        async getServerConsole(mode) {
            if (!mode) {
                mode = this.canUseWebConsole ? 'web' : this.canUseStandardConsole ? 'standard' : null;
            }

            this.$refs.openServerConsole.open(mode);
        }
    },

    props: [
        'xhrUrl',
        'serverData',
    ],

    components: {
        OpenServerConsole,
    }
}