function initialStateAlertDialog() {
    return {
        dialog: false,
        resolve: null,
        reject: null,
        message: 'Are you sure you want to perform this action? It may not be possible to undo this operation.',
        title: 'Confirm',
        buttonAcceptText: 'Delete',
        buttonCancelText: 'Close',
        acceptIcon: '',
        alertMessage: '',
    }
}


export default {
    template: `
        <div class="modal fade" :id="'alertDialog_' + _uid" tabindex="-1" role="dialog" aria-labelledby="alertDialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header panel-heading ds-bg-danger ds-text-white">
                    <h5 class="modal-title ds-modal-title">{{ title }}</h5>
                </div>
                <div class="modal-body">
                    <span v-html="message"></span>

                    <div v-if="alertMessage" class="alert alert-danger" style="margin-top: 10px; margin-bottom: 5px;">
                        <span v-html="alertMessage"></span>
                    </div>
                </div>
                <div class="modal-footer panel-footer card-footer">
                    <button type="button" class="btn btn-secondary pull-left float-left" data-dismiss="modal">
                        <i :class="faIconRepo('fa-times')" style="margin-right: 3px;"></i>
                        {{ buttonCancelText }}
                    </button>

                    <button @click="agree" type="button" class="btn btn-danger pull-right float-right">
                        <i :class="acceptIcon" style="margin-right: 3px;"></i>
                        {{ buttonAcceptText }}
                    </button>
                </div>
            </div>
        </div>
        </div>
    `,

    data: () => {
        return initialStateAlertDialog();
    },

    computed: {
        show: {
            get() {
                return this.dialog
            },
            set(value) {
                this.dialog = value
                if (value === false) {
                    this.cancel()
                }
            }
        }
    },

    methods: {
        open(title, message, buttonCancelText, buttonAcceptText, acceptIcon, alertMessage) {
            Object.assign(this.$data, initialStateAlertDialog());
            jQuery('#alertDialog_' + this._uid).modal({show: true});

            if (!acceptIcon) {
                this.acceptIcon = this.faIconRepo('fa-check');
            }

            this.dialog = true

            if (title) {
                this.title = title
            }

            if (message) {
                this.message = message
            }

            if (buttonAcceptText) {
                this.buttonAcceptText = buttonAcceptText;
            }

            if (buttonCancelText) {
                this.buttonCancelText = buttonCancelText;
            }

            if (acceptIcon) {
                this.acceptIcon = acceptIcon;
            }

            if (alertMessage) {
                this.alertMessage = alertMessage;
            }

            return new Promise((resolve, reject) => {
                this.resolve = resolve
                this.reject = reject
            })
        },

        async agree() {
            this.resolve(true);
            jQuery('#alertDialog_' + this._uid).modal('hide');
        },

        cancel() {
            this.resolve(false);
            jQuery('#alertDialog_' + this._uid).modal('hide');
        }
    }
}
